<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Temp_server_model extends My_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    public function getRecords($params = [])
    {
        $params = init_model_params($params);
        $this->db->select(ADMIN_TEMP_SERVER_FETCH_FIELD);
        get_where($params['where']);
        $this->db->from($this->temp_server_table . ' AS temp_server');
        if ($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'], $params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function insertOVPNServer($postdata){
        $server = [];
        $server['country_id'] = $postdata['country_id'];
        $server['ip_address'] = $postdata['ip_address'];
        $server['recommend'] = $postdata['recommend'] ?? 0;
        $server['is_active'] = $postdata['is_active'] ?? 0;
        $server['ovpn'] = $postdata['ovpn'] ?? '';
        $server['ping_count'] = $postdata['ping_count'] ?? 0;
        $server['created_at'] = time();
        $server['updated_at'] = time();
        $this->db->insert($this->temp_server_table, $server);
        return $this->db->insert_id();
    }
    
    public function updateOVPNServer($postdata){
        $server = [];
        if(isset($postdata['country_id'])){ $server['country_id'] = $postdata['country_id']; }
        if(isset($postdata['ip_address'])){ $server['ip_address'] = $postdata['ip_address']; }
        if(isset($postdata['recommend'])){ $server['recommend'] = $postdata['recommend'] ?? 0; }
        if(isset($postdata['is_active'])){ $server['is_active'] = $postdata['is_active'] ?? 0; }
        if(isset($postdata['ovpn'])){ $server['ovpn'] = $postdata['ovpn'] ?? ''; }
        if(isset($postdata['ping_count'])){ $server['ping_count'] = $postdata['ping_count'] ?? 0; }
        if(isset($postdata['updated_at'])){ $server['updated_at'] = time(); }
        $this->db->where('server_id', $postdata['server_id']);
        return $this->db->update($this->temp_server_table, $server);
    }
    
    public function deleteTempServer($server_id){
        $this->db->where('server_id',$server_id);
        $flag = $this->db->delete($this->temp_server_table);
        if(!$flag){
            return FALSE;
        }
        return TRUE;
    }
}
