<?php
defined('BASEPATH') or exit('No direct script access allowed');

class User_model extends My_Model {

    public function __construct()
    {
        parent::__construct();
    }

    public function getRow($id)
    {
        return $this->getRecords(['where'=>['user.user_id'=>$id],'action'=>'row']);
    }

    public function getRowByEmail($email)
    {
        return $this->getRecords(['where'=>['user.email'=>$email],'action'=>'row']);
    }

    public function _getDatatableList($params = [])
    {
        $params = init_model_params($params);

        $fields = array_merge(API_FIELDS_WEBHOOK_SUBSCRIPTION, API_FIELDS_USER_SUBSCRIPTION, API_FIELDS_DEVICE);
        $this->db->select($fields);
        $this->db->from($this->user_subscription_table.' AS usubscription');
        $this->db->join($this->user_table.' AS user','user.user_id = usubscription.user_id');
        $this->db->join($this->user_device_table.' AS device','device.user_device_id = usubscription.user_device_id');
        $this->db->join($this->webhook_subscription_table.' AS web_subscription','web_subscription.original_transaction_id = usubscription.original_transaction_id AND web_subscription.is_latest_webhook = 1','LEFT');
        $user_trans_query = $this->db->get_compiled_select();

        $wholesaler = 'IF(
            web_subscription.notification_store != "'.APP_STORE_APPLE.'" AND device.wholesaler_user IS NULL,
            CONCAT(web_subscription.original_transaction_id,"@vpw.vpnproxymaster.app"),
            IFNULL(device.wholesaler_user,
                IF(web_subscription.notification_store IS NOT NULL,CONCAT(device.device_unique_id,"@vpw.vpnproxymaster.app"),"")
            )
        ) AS wholesaler_user';
        $fields = array_merge(API_FIELDS_WEBHOOK_SUBSCRIPTION, API_FIELDS_USER, API_FIELDS_DEVICE, API_FIELDS_EMAIL_VERIFICATION_STATUS, ['user.is_deleted','user.created_at',$wholesaler]);
        $this->db->select($fields);
        get_where($params['where']);
        get_filter_where(USERS_SEARCHABLE_FIELDS);
        $this->db->from($this->user_table.' AS user');
        $this->db->join($this->email_verification_table.' AS email_verify','email_verify.user_id = user.user_id','LEFT');
        $this->db->join('('.$user_trans_query.') AS web_subscription','web_subscription.user_id = user.user_id','LEFT');
        $this->db->join($this->user_device_table.' AS device','device.user_device_id = web_subscription.user_device_id','LEFT');
        if($params['action'] != 'count'){
            get_filter_order($_REQUEST, $params['order'], USERS_ORDERABLE_FIELDS);
            get_limit($params['limit'], $params['offset']);
        }
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function getDatatableList($params = [])
    {
        $params = init_model_params($params);
        $fields = array_merge(API_FIELDS_WEBHOOK_SUBSCRIPTION, API_FIELDS_USER, API_FIELDS_DEVICE, API_FIELDS_EMAIL_VERIFICATION_STATUS, ['user.is_deleted','user.created_at']);
        $this->db->select($fields);
        get_where($params['where']);
        get_filter_where(USERS_SEARCHABLE_FIELDS);
        $this->db->from($this->user_table.' AS user');
        $this->db->join($this->email_verification_table.' AS email_verify','email_verify.user_id = user.user_id','LEFT');
        $this->db->join($this->user_subscription_table.' AS usubscription','usubscription.user_id = user.user_id AND usubscription.is_latest_webhook_subscription = 1','LEFT');
        $this->db->join($this->webhook_subscription_table.' AS web_subscription','web_subscription.original_transaction_id = usubscription.original_transaction_id AND web_subscription.is_latest_webhook = 1','LEFT');
        $this->db->join($this->user_device_table.' AS device','device.user_device_id = usubscription.user_device_id','LEFT');
        if($params['action'] != 'count'){
            get_filter_order($_REQUEST, $params['order'], USERS_ORDERABLE_FIELDS);
            get_limit($params['limit'], $params['offset']);
        }
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function totalRevenue($params = [])
    {
        $params = init_model_params($params);
        $this->db->select('sum(web_subscription.price) AS total');
        get_where($params['where']);
        get_filter_where(USERS_SEARCHABLE_FIELDS);
        $this->db->from($this->user_subscription_table.' AS usubscription');
        $this->db->join($this->webhook_subscription_table.' AS web_subscription','web_subscription.original_transaction_id = usubscription.original_transaction_id');
        if($params['action'] != 'count'){
            get_filter_order($_REQUEST, $params['order'], USERS_ORDERABLE_FIELDS);
            get_limit($params['limit'], $params['offset']);
        }
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }
    
    public function _getTransactions($params = [])
    {
        $params = init_model_params($params);
        /* $this->db->select('web_subscription_tran.*');
        $this->db->from($this->webhook_subscription_table.' AS web_subscription_tran');
        $transaction_query = $this->db->get_compiled_select(); */
        
        $fields = array_merge(API_FIELDS_WEBHOOK_SUBSCRIPTION, API_FIELDS_USER_SUBSCRIPTION);
        $this->db->select($fields);
        $this->db->from($this->user_subscription_table.' AS usubscription');
        $this->db->join($this->user_table.' AS user','user.user_id = usubscription.user_id');
        $this->db->join($this->webhook_subscription_table.' AS web_subscription','web_subscription.original_transaction_id = usubscription.original_transaction_id');
        $user_trans_query = $this->db->get_compiled_select();

        $fields = array_merge(API_FIELDS_USER, API_FIELDS_WEBHOOK_SUBSCRIPTION);
        $this->db->select($fields);
        get_where($params['where']);
        $this->db->from($this->user_table.' AS user');
        $this->db->join('('.$user_trans_query.') AS web_subscription','web_subscription.user_id = user.user_id');
        if($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'],$params['offset']);
        $this->db->distinct();
        $query = $this->db->get();
        return get_data($params, $query);
    }
    
    public function getTransactions($params = [])
    {
        $params = init_model_params($params);
        $fields = array_merge(API_FIELDS_USER, API_FIELDS_WEBHOOK_SUBSCRIPTION);
        $this->db->select($fields);
        get_where($params['where']);
        $this->db->from($this->user_table.' AS user');
        $this->db->join($this->user_subscription_table.' AS usubscription','usubscription.user_id = user.user_id AND usubscription.is_latest_webhook_subscription = 1');
        $this->db->join($this->webhook_subscription_table.' AS web_subscription','web_subscription.original_transaction_id = usubscription.original_transaction_id AND web_subscription.is_latest_webhook = 1');
        if($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function getAllTransactions($params = [])
    {
        $params = init_model_params($params);
        $fields = array_merge(API_FIELDS_USER, API_FIELDS_WEBHOOK_SUBSCRIPTION);
        $this->db->select($fields);
        get_where($params['where']);
        $this->db->from($this->user_table.' AS user');
        $this->db->join($this->user_subscription_table.' AS usubscription','usubscription.user_id = user.user_id');
        $this->db->join($this->webhook_subscription_table.' AS web_subscription','web_subscription.original_transaction_id = usubscription.original_transaction_id');
        if($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function getTransactionsFull($params = [])
    {
        $params = init_model_params($params);
        $fields = array_merge(API_FIELDS_WEBHOOK_SUBSCRIPTION, API_FIELDS_USER_SUBSCRIPTION);
        $this->db->select($fields);
        $this->db->from($this->user_subscription_table.' AS usubscription');
        $this->db->join($this->user_table.' AS user','user.user_id = usubscription.user_id');
        $this->db->join($this->webhook_subscription_table.' AS web_subscription','web_subscription.original_transaction_id = usubscription.original_transaction_id');
        $user_trans_query = $this->db->get_compiled_select();

        $fields = array_merge(API_FIELDS_WEBHOOK_SUBSCRIPTION,['subs_receipt.latest_receipt']);
        $this->db->select($fields);
        get_where($params['where']);
        $this->db->from($this->user_table.' AS user');
        $this->db->join('('.$user_trans_query.') AS web_subscription','web_subscription.user_id = user.user_id');
        $this->db->join($this->subscription_receipt_table.' AS subs_receipt','subs_receipt.transaction_id = web_subscription.transaction_id','LEFT');
        if($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'],$params['offset']);
        $this->db->distinct();
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function getTransactionMappings($params = []){
        $params = init_model_params($params);
        $this->db->select('usubscription.*');
        $this->db->from($this->user_subscription_table . ' AS usubscription');
        $this->db->join($this->user_table . ' AS user', 'user.user_id = usubscription.user_id');
        get_where($params['where']);
        if($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function getRecords($params = [])
    {
        $params = init_model_params($params);
        $fields = array_merge(API_FIELDS_USER, API_FIELDS_EMAIL_VERIFICATION, ["user.created_at"]);
        $this->db->select($fields);
        get_where($params['where']);
        $this->db->from($this->user_table.' AS user');
        $this->db->join($this->email_verification_table.' AS email_verify','email_verify.user_id = user.user_id','LEFT');
        if($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function getDeviceDetails($params = [])
    {
        $this->db->select('device_user.user_id,device_user.user_device_id,max(device_user.user_device_login_id) as max_user_device_login_id,device_user.login_at');
        $this->db->from($this->user_device_login_table.' AS device_user');
        get_where($params['where']);
        $this->db->group_by('device_user.user_device_id');
        $last_login_query = $this->db->get_compiled_select();

        $params = init_model_params($params);
        $fields = array_merge(API_FIELDS_DEVICE,['device.created_at','device_user.login_at']);
        $this->db->select($fields);
        get_where($params['where']);
        $this->db->from($this->user_device_login_table.' AS device_login');
        $this->db->join('('.$last_login_query.') AS device_user','device_user.max_user_device_login_id = device_login.user_device_login_id');
        $this->db->join($this->user_device_table.' AS device','device_user.user_device_id = device.user_device_id');
        if($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function getWebhookDataFromTransactionIds($transaction_ids){
        $this->db->select(API_FIELDS_WEBHOOK_SUBSCRIPTION);
        $this->db->from($this->webhook_subscription_table.' AS web_subscription');
        $this->db->where_in('web_subscription.transaction_id', $transaction_ids);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function deleteAccount($user_id)
    {
        $postdata = [];
        $postdata['is_deleted'] = TRUE;
        $postdata['updated_at'] = time();
        $this->db->where('user_id', $user_id);
        $flag = $this->db->update($this->user_table, $postdata);
        if (!$flag) {
            return FALSE;
        }
        return $this->db->affected_rows();
    }

    public function activateAccount($user_id)
    {
        $postdata = [];
        $postdata['is_deleted'] = FALSE;
        $postdata['updated_at'] = time();
        $this->db->where('user_id', $user_id);
        $flag = $this->db->update($this->user_table, $postdata);
        if (!$flag) {
            return FALSE;
        }
        return $this->db->affected_rows();
    }

    public function get_active_users($params = []){
        $params = init_model_params($params);
        // $fields = array_merge(API_FIELDS_WEBHOOK_SUBSCRIPTION,API_FIELDS_DEVICE,['receipt.latest_receipt']);
        $fields = array_merge(API_FIELDS_WEBHOOK_SUBSCRIPTION,API_FIELDS_DEVICE);
        $this->db->select($fields);
        $this->db->from($this->webhook_subscription_table.' AS web_subscription');
		$this->db->join($this->user_subscription_table.' AS usubscription','web_subscription.original_transaction_id = usubscription.original_transaction_id AND usubscription.is_latest_webhook_subscription = 1');
		// $this->db->join($this->subscription_receipt_table.' AS receipt','receipt.transaction_id = web_subscription.original_transaction_id');
		$this->db->join($this->user_device_table.' AS device','device.user_device_id = usubscription.user_device_id');
        get_where($params['where']);
        if($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }
}