<!-- Navbar -->
<nav class="main-header navbar navbar-white navbar-light navbar-expand-lg">
    <a href="<?= ADMIN_URL; ?>" class="navbar-brand p-0">
        <img src="<?= WEBLOGO_URL; ?>" alt="<?= WEBSITE_TITLE; ?>" class="brand-image" style="max-height: 30px;">
    </a>
    <button class="navbar-toggler order-1 collapsed" type="button" data-toggle="collapse" data-target="#navbarCollapse" aria-controls="navbarCollapse" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
    </button>
    <?php $controller = str_replace('_', '-', $this->router->fetch_class()); ?>


    <div class="collapse navbar-collapse order-3" id="navbarCollapse">
        <ul class="navbar-nav">
            <?php
            $module = 'dashboard';
            $active = ($controller == $module) ? 'active' : '';
            ?>
            <li class="nav-item">
                <a href="<?= ADMIN_URL . $module; ?>" class="d-flex nav-link <?= $active; ?>">
                    <i class="align-self-center nav-icon fas fa-tachometer-alt mr-1"></i>
                    <p>Dashboard</p>
                </a>
            </li>
            <?php
            $module = 'user';
            $active = ($controller == $module) ? 'active' : '';
            $permission_auth = $this->authlib->isAuthorizedLink($permissions, $module);
            if ($permission_auth) :
            ?>
                <li class="nav-item">
                    <a href="<?= ADMIN_URL . $module; ?>" class="d-flex nav-link <?= $active; ?>">
                        <i class="align-self-center nav-icon fas fa-user-shield mr-1"></i>
                        <p>Users</p>
                    </a>
                </li>
            <?php endif; ?>
            <?php
            $module = 'guest-user';
            $active = ($controller == $module) ? 'active' : '';
            $permission_auth = $this->authlib->isAuthorizedLink($permissions, $module);
            if ($permission_auth) :
            ?>
                <li class="nav-item">
                    <a href="<?= ADMIN_URL . $module; ?>" class="d-flex nav-link <?= $active; ?>">
                        <i class="align-self-center nav-icon fas fa-user-secret mr-1"></i>
                        <p><?= plural(humanize($module, "-")); ?></p>
                    </a>
                </li>
            <?php endif; ?>
            <?php
            $module = 'open-gate-server';
            $active = ($controller == $module) ? 'active' : '';
            $permission_auth = $this->authlib->isAuthorizedLink($permissions, $module);
            if ($permission_auth) :
            ?>
                <li class="nav-item">
                    <a href="<?= ADMIN_URL . $module; ?>" class="d-flex nav-link <?= $active; ?>">
                        <i class="align-self-center nav-icon fas fa-globe mr-1"></i>
                        <p><?= plural(humanize($module, "-")); ?></p>
                    </a>
                </li>
            <?php endif; ?>
            <?php
            $module = 'country';
            $active = ($controller == $module) ? 'active' : '';
            $permission_auth = $this->authlib->isAuthorizedLink($permissions, $module);
            if ($permission_auth) :
            ?>
                <li class="nav-item">
                    <a href="<?= ADMIN_URL . $module; ?>" class="d-flex nav-link <?= $active; ?>">
                        <i class="align-self-center nav-icon fas fa-flag mr-1"></i>
                        <p><?= plural(humanize($module, "-")); ?></p>
                    </a>
                </li>
            <?php endif; ?>
            <?php
            $module = 'vpn-server';
            $active = ($controller == $module) ? 'active' : '';
            $permission_auth = $this->authlib->isAuthorizedLink($permissions, $module);
            if ($permission_auth) :
            ?>
                <li class="nav-item">
                    <a href="<?= ADMIN_URL . $module; ?>" class="d-flex nav-link <?= $active; ?>">
                        <i class="align-self-center nav-icon fas fa-server mr-1"></i>
                        <p><?= plural(humanize($module, "-")); ?></p>
                    </a>
                </li>
            <?php endif; ?>

            <?php
            $module = 'subscription-stat';
            $active = ($controller == $module) ? 'active' : '';
            $permission_auth = $this->authlib->isAuthorizedLink($permissions, $module);
            if ($permission_auth) :
            ?>
                <li class="nav-item">
                    <a href="<?= ADMIN_URL . $module; ?>" class="d-flex nav-link <?= $active; ?>">
                        <i class="align-self-center nav-icon fas fa-bars mr-1"></i>
                        <p><?= plural(humanize($module, "-")); ?></p>
                    </a>
                </li>
            <?php endif; ?>

            <?php
            $active = (in_array($controller, ['module', 'method', 'role', 'admin'])) ? 'active' : '';
            $module_auth = $this->authlib->isAuthorizedLink($permissions, 'module');
            $method_auth = $this->authlib->isAuthorizedLink($permissions, 'method');
            $role_auth = $this->authlib->isAuthorizedLink($permissions, 'role');
            $admin_auth = $this->authlib->isAuthorizedLink($permissions, 'admin');
            if ($module_auth || $method_auth || $role_auth || $admin_auth) :
            ?>
                <li class="nav-item dropdown">
                    <a id="dropdownSubMenu0" href="#" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" class="nav-link dropdown-toggle">
                        <i class="align-self-center nav-icon fas fa-cogs mr-1"></i>
                        Admin Settings
                    </a>
                    <ul class="border-0 dropdown-menu pl-2 pr-2 shadow" aria-labelledby="dropdownSubMenu0">
                        <?php
                        $module = 'module';
                        $active = ($controller == $module) ? 'active' : '';
                        $active_sub = ($controller == $module) ? 'fa-check-circle' : 'fa-circle';
                        if ($module_auth) :
                        ?>
                            <li>
                                <a href="<?= ADMIN_URL . $module; ?>" class="d-flex nav-link <?= $active; ?>">
                                    <i class="align-self-center far nav-icon mr-1 <?= $active_sub; ?>"></i>
                                    <p>Modules</p>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php
                        $module = 'method';
                        $active = ($controller == $module) ? 'active' : '';
                        $active_sub = ($controller == $module) ? 'fa-check-circle' : 'fa-circle';
                        if ($method_auth) :
                        ?>
                            <li>
                                <a href="<?= ADMIN_URL . $module; ?>" class="d-flex nav-link <?= $active; ?>">
                                    <i class="align-self-center far nav-icon mr-1 <?= $active_sub; ?>"></i>
                                    <p>Methods</p>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php
                        $module = 'role';
                        $active = ($controller == $module) ? 'active' : '';
                        $active_sub = ($controller == $module) ? 'fa-check-circle' : 'fa-circle';
                        if ($role_auth) :
                        ?>
                            <li>
                                <a href="<?= ADMIN_URL . $module; ?>" class="d-flex nav-link <?= $active; ?>">
                                    <i class="align-self-center far nav-icon mr-1 <?= $active_sub; ?>"></i>
                                    <p>Roles</p>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php
                        $module = 'admin';
                        $active = ($controller == $module) ? 'active' : '';
                        $active_sub = ($controller == $module) ? 'fa-check-circle' : 'fa-circle';
                        if ($admin_auth) :
                        ?>
                            <li>
                                <a href="<?= ADMIN_URL . $module; ?>" class="d-flex nav-link <?= $active; ?>">
                                    <i class="align-self-center far nav-icon mr-1 <?= $active_sub; ?>"></i>
                                    <p>Admins</p>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <li class="nav-item">
                    <a href="javascript:void(0)" class="d-flex nav-link logout" data-redirect-link="<?= ADMIN_URL . 'logout'; ?>">
                        <i class="align-self-center nav-icon fas fa-sign-out-alt mr-1"></i>
                        <p>Logout</p>
                    </a>
                </li>
            <?php endif; ?>
        </ul>
    </div>

    <!-- Right navbar links -->
    <ul class="order-1 order-md-3 navbar-nav navbar-no-expand ml-auto">
        <!-- Messages Dropdown Menu -->
        <!-- <li class="nav-item dropdown">
            <a class="nav-link" data-toggle="dropdown" href="#">
            <i class="far fa-comments"></i>
            <span class="badge badge-danger navbar-badge">3</span>
            </a>
            <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
            <a href="#" class="dropdown-item">
                <div class="media">
                <img src="<?= ADMIN_DIST_URL; ?>img/user1-128x128.jpg" alt="User Avatar" class="img-size-50 mr-3 img-circle">
                <div class="media-body">
                    <h3 class="dropdown-item-title">
                    Brad Diesel
                    <span class="float-right text-sm text-danger"><i class="fas fa-star"></i></span>
                    </h3>
                    <p class="text-sm">Call me whenever you can...</p>
                    <p class="text-sm text-muted"><i class="far fa-clock mr-1"></i> 4 Hours Ago</p>
                </div>
                </div>
            </a>
            <div class="dropdown-divider"></div>
            <a href="#" class="dropdown-item">
                <div class="media">
                <img src="<?= ADMIN_DIST_URL; ?>img/user8-128x128.jpg" alt="User Avatar" class="img-size-50 img-circle mr-3">
                <div class="media-body">
                    <h3 class="dropdown-item-title">
                    John Pierce
                    <span class="float-right text-sm text-muted"><i class="fas fa-star"></i></span>
                    </h3>
                    <p class="text-sm">I got your message bro</p>
                    <p class="text-sm text-muted"><i class="far fa-clock mr-1"></i> 4 Hours Ago</p>
                </div>
                </div>
            </a>
            <div class="dropdown-divider"></div>
            <a href="#" class="dropdown-item">
                <div class="media">
                <img src="<?= ADMIN_DIST_URL; ?>img/user3-128x128.jpg" alt="User Avatar" class="img-size-50 img-circle mr-3">
                <div class="media-body">
                    <h3 class="dropdown-item-title">
                    Nora Silvester
                    <span class="float-right text-sm text-warning"><i class="fas fa-star"></i></span>
                    </h3>
                    <p class="text-sm">The subject goes here</p>
                    <p class="text-sm text-muted"><i class="far fa-clock mr-1"></i> 4 Hours Ago</p>
                </div>
                </div>
            </a>
            <div class="dropdown-divider"></div>
            <a href="#" class="dropdown-item dropdown-footer">See All Messages</a>
            </div>
        </li> -->
        <!-- Notifications Dropdown Menu -->
        <!-- <li class="nav-item dropdown">
            <a class="nav-link" data-toggle="dropdown" href="#">
            <i class="far fa-bell"></i>
            <span class="badge badge-warning navbar-badge">15</span>
            </a>
            <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
            <span class="dropdown-item dropdown-header">15 Notifications</span>
            <div class="dropdown-divider"></div>
            <a href="#" class="dropdown-item">
                <i class="fas fa-envelope mr-2"></i> 4 new messages
                <span class="float-right text-muted text-sm">3 mins</span>
            </a>
            <div class="dropdown-divider"></div>
            <a href="#" class="dropdown-item">
                <i class="fas fa-users mr-2"></i> 8 friend requests
                <span class="float-right text-muted text-sm">12 hours</span>
            </a>
            <div class="dropdown-divider"></div>
            <a href="#" class="dropdown-item">
                <i class="fas fa-file mr-2"></i> 3 new reports
                <span class="float-right text-muted text-sm">2 days</span>
            </a>
            <div class="dropdown-divider"></div>
            <a href="#" class="dropdown-item dropdown-footer">See All Notifications</a>
            </div>
        </li> -->
        <li class="nav-item dropdown">
            <a href="javascript:void(0);" id="profilerToggle" class="btn btn-secondary btn-xs hide ml-1">Hide Profiles</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" data-widget="fullscreen" href="javascript:void(0)" role="button">
                <i class="fas fa-expand-arrows-alt"></i>
            </a>
        </li>
        <?php $loggedIn['admin_profilepic'] = getFilePath($loggedIn['admin_profilepic']); ?>
        <li class="nav-item dropdown">
            <a class="nav-link" data-toggle="dropdown" href="#">
                <img src="<?= $loggedIn['admin_profilepic']; ?>" class="action-bar-profile-img img-circle elevation-2" alt="<?= $loggedIn['admin_fullname']; ?>">
            </a>
            <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                <div class="card mb-0">
                    <div class="card-body">
                        <div class="text-center">
                            <a class="fancybox" href="<?= $loggedIn['admin_profilepic']; ?>"><img src="<?= $loggedIn['admin_profilepic']; ?>" alt="<?= $loggedIn['admin_fullname']; ?>" class="img-size-64 img-circle"></a>
                            <div class="mt-2">
                                <h3 class="dropdown-item-title"><?= $loggedIn['admin_fullname']; ?></h3>
                                <p class="text-sm"><?= $loggedIn['admin_email']; ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="justify-content-between d-flex">
                            <a class="btn btn-theme-success" href="<?= ADMIN_URL . 'profile'; ?>">Profile</a>
                            <a class="btn btn-theme-cancel logout" href="javascript:void(0)" data-redirect-link="<?= ADMIN_URL . 'logout'; ?>">Logout</a>
                        </div>
                    </div>
                </div>
            </div>
        </li>
        <!-- <li class="nav-item">
            <a class="nav-link" data-widget="control-sidebar" data-slide="true" href="#" role="button">
            <i class="fas fa-th-large"></i>
            </a>
        </li> -->
    </ul>
</nav>
<!-- /.navbar -->