<?php
    $permission_auth = $this->authlib->isAuthorizedLink($permissions,$module,'permission');
    if($permission_auth):
?>
<div class="modal fade" id="permission-modal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Update Role Permissions</h4>
                <button type="button" class="align-self-center btn btn-sm btn-outline-dark justify-content-between" data-dismiss="modal"><i class="fa fa-times"></i></button>
            </div>
            <?php echo form_open('#', $forms['frm_permission']); ?>
            <div class="modal-body">
                <div class="row">
                    <?php echo form_hidden('role_id', ''); ?>
                    <?php if(!empty($modules) && count($modules) > 0): ?>
                        <?php foreach($modules as $this_module): ?>
                            <div class="col-12">
                                <div class="card permissionmenu">
                                    <div class="card-header">
                                        <div class="d-flex justify-content-between">
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" id="customSwitch-group<?=$this_module['module_id'];?>">
                                                <label class="custom-control-label" for="customSwitch-group<?=$this_module['module_id'];?>"><?=$this_module['module_title'];?></label>
                                            </div>
                                            <div claas="card-tools">
                                                <button type="button" class="btn btn-sm btn-tool btn-default btn-collapse" data-toggle="collapse" href="#collapseModule-<?=$this_module['module_id'];?>"><i class="fa fa-minus fa-plus"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if (!empty($this_module['methods']) && count($this_module['methods']) > 0): ?>
                                    <ul class="list-unstyled card-body permissions collapse" id="collapseModule-<?=$this_module['module_id'];?>">
                                        <?php foreach ($this_module['methods'] as $method): ?>
                                        <li>
                                        <?php //$checked = (in_array($method['module_method_id'], $row['selected_permissions'])) ? 'checked' : ''; ?>
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" name="permissions[]" class="custom-control-input" id="customSwitch-<?=$method['module_method_id'];?>" value="<?=$method['module_method_id'];?>">
                                                <label class="custom-control-label" for="customSwitch-<?=$method['module_method_id'];?>"><?=$method['method_title'];?></label>
                                            </div>
                                        </li>
                                        <?php endforeach;?>
                                    </ul>
                                    <?php endif;?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-theme-success">Save</button>
                <button type="button" class="btn btn-theme-cancel" data-dismiss="modal">Cancel</button>
            </div>
            <?php echo form_close(); ?>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<?php endif; ?>