<?php if(empty($transactions)): ?>
<div class="card mb-0">
    <div class="card-body">
        <div class="form-row">
            <div class="col"><div class="text-center">No transactions found</div>
        </div>
    </div>
</div>
<?php else: ?>
<div class="card bg-transparent">
    <div class="card-header bg-white"><div class="card-title">Transaction History</div></div>
    <div class="card-body">
<?php 
    $transactions = array_map(function($transaction) use ($offset){
        $transaction['original_purchase_date'] = date(DATE_FORMAT,($transaction['original_purchase_date_ms'] / 1000) + $offset);
        $transaction['purchase_date'] = date(DATE_FORMAT,($transaction['purchase_date_ms'] / 1000) + $offset);
        $transaction['expires_date'] = date(DATE_FORMAT,($transaction['expires_date_ms'] / 1000) + $offset);
        $transaction['created_date'] = date(DATE_FORMAT,$transaction['created_at'] + $offset);
        return $transaction;
    }, $transactions);
    $created_dates = array_unique(array_column($transactions, 'created_date'));

    $i=0;
    foreach ($created_dates as $created_date):
        $datewise_transactions = array_filter($transactions,function($transaction) use ($created_date){
            return ($transaction['created_date'] == $created_date) ? $transaction : FALSE;
        });
        $cardClass = ($i > 0) ? "card mb-2 collapsed-card" : "card mb-2";
        $cardMinMaxiCon = ($i > 0) ? "plus" : "minus";
        $i++;
?>
<div class="<?=$cardClass;?>">
    <div class="card-header">
        <h3 class="card-title"><?=$created_date;?></h3>
        <div class="card-tools">
            <button type="button" class="btn btn-tool btn-default" data-card-widget="collapse"><i class="fas fa-<?=$cardMinMaxiCon;?>"></i></button>
        </div>
    </div>
    <div class="card-body">
        <div class="form-row">
            <div class="col">
                <?php foreach ($datewise_transactions as $transaction): ?>
                <?php
                    $timelineBody = '';
                    $purchaseDate = date(DATETIME_FORMAT,($transaction['purchase_date_ms'] / 1000) + $offset);
                    $expireDate = date(DATETIME_FORMAT,($transaction['expires_date_ms'] / 1000) + $offset);
                    $cancelledDateTime = date(DATETIME_FORMAT,($transaction['cancellation_date_ms'] / 1000) + $offset);
                    $authRenewalDateTime = date(DATETIME_FORMAT,($transaction['auto_renew_status_change_date_ms'] / 1000) + $offset);
                    
                    $productIdFormatted = '<strong>'.$transaction['product_id'].'</strong>';
                    $purchaseDateFormatted = '<strong>'.$purchaseDate.'</strong>';
                    $expireDateFormatted = '<strong>'.$expireDate.'</strong>';
                    $cancelledDateTimeFormatted = '<strong>'.$cancelledDateTime.'</strong>';
                    $authRenewalDateTimeFormatted = '<strong>'.$authRenewalDateTime.'</strong>';

                    $icon = 'fa-envelope';
                    $notifier_type = strtoupper($transaction['notification_store'])."_".$transaction['notification_type'];
                    switch ($notifier_type) {
                        case 'APPLE_DID_CHANGE_RENEWAL_STATUS':
                        case 'AMAZON_SUBSCRIPTION_AUTO_RENEWAL_OFF':
                        case 'AMAZON_SUBSCRIPTION_AUTO_RENEWAL_ON':
                            $icon = 'fa-sync';
                            $statusStr = (boolval($transaction['auto_renew_status'])) ? 'enabled' : 'disabled';
                            $timelineBody = ucfirst($statusStr).' their subscription of '.$productIdFormatted.' at '.$authRenewalDateTimeFormatted;
                            break;
                        case 'APPLE_INTERACTIVE_RENEWAL':
                            $icon = 'fa-sync';
                            $timelineBody = 'Customer renewed their subscription of '.$productIdFormatted.' applicable from '.$purchaseDateFormatted.' to '.$expireDateFormatted;
                            break;
                        case 'APPLE_DID_RENEW':
                        case 'ANDROID_SUBSCRIBED':
                        case 'AMAZON_SUBSCRIPTION_RENEWED':
                        case 'AMAZON_SUBSCRIPTION_CONVERTED_FREE_TRIAL_TO_PAID':
                            $icon = 'fa-sync';
                            $timelineBody = 'Auto-renewed their subscription of '.$productIdFormatted.' applicable from '.$purchaseDateFormatted.' to '.$expireDateFormatted;
                            break;
                        case 'APPLE_INITIAL_BUY':
                        case 'ANDROID_INITIAL_BUY':
                        case 'AMAZON_SUBSCRIPTION_PURCHASED':
                            $icon = 'fa-shopping-cart';
                            $timelineBody = 'User\'s initial purchase of the subscription of '.$productIdFormatted;
                            break;
                        case 'APPLE_CANCEL':
                        case 'ANDROID_CANCEL':
                        case 'AMAZON_SUBSCRIPTION_CANCELLED':
                            $icon = 'fa-times-circle';
                            $timelineBody = 'Cancelled their subscription of '.$productIdFormatted.' at '.$cancelledDateTimeFormatted;
                            break;
                        case 'APPLE_DID_FAIL_TO_RENEW':
                            $icon = 'fa-times-circle';
                            $timelineBody = 'Failed to renews their subscription of '.$productIdFormatted;
                            break;
                        case 'APPLE_DID_RECOVER':
                        case 'ANDROID_SUBSCRIPTION_RECOVERED':
                            $icon = 'fa-undo';
                            $timelineBody = 'Restore their subscription of '.$productIdFormatted.' applicable from '.$purchaseDateFormatted.' to '.$expireDateFormatted;
                            break;
                        case 'APPLE_EXPIRED':
                        case 'ANDROID_EXPIRED':
                        case 'AMAZON_SUBSCRIPTION_EXPIRED':
                            $icon = 'fa-times-circle';
                            $timelineBody = 'Subscription of '.$productIdFormatted.' has been expired';
                            break;
                        case 'AMAZON_SUBSCRIPTION_SCHEDULED_TO_END':
                            $icon = 'fa-times-circle';
                            $timelineBody = 'Subscription of '.$productIdFormatted.' has been scheduled to end because the auto-renew feature was turned off';
                            break;
                        default:
                            $timelineBody = $transaction['notification_type'];
                            # code...
                            break;
                    }
                ?>
                <div class="row">
                    <div class="col-10">
                        <ul class="ml-4 mb-0 fa-ul text-muted">
                            <li class=""><span class="fa-li"><i class="align-middle fas fa-lg <?=$icon;?>"></i></span> <?=$timelineBody;?></li>
                        </ul>
                    </div>
                    <div class="col-2 text-right">
                        <p class="small"><i class="fas fa-clock text-gray"></i> <?=date(TIME_FORMAT,($transaction['purchase_date_ms'] / 1000) + $offset);?></p>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>
<?php endforeach; ?>
    </div>
</div>
<?php endif; ?>