<?php
    $data_columns = [];
    if(isset($columns) && !empty($columns) && count($columns) > 0):
        $data_columns = array_map(function($col){
            return ['data' => $col['id'] ?? $col['type']];
        }, $columns);
    endif;
    $data_columns = json_encode($data_columns);
?>
<script>
var table;
$(document).ready(function(){
    if($("#datatable").length > 0){
        table = $("#datatable").DataTable({
            "select": true,
            "responsive": { details: { type: 'inline' } },
            "fixedHeader": {
                header: true,
                headerOffset: $('nav.main-header').outerHeight()
            },
            "dom": 'Bfrtip',
            // "dom": 'PBfrtip',
            "lengthChange": true,
            "autoWidth": false,
            "lengthMenu": [
                [ 10, 25, 50, -1 ],
                [ '10 rows', '25 rows', '50 rows', 'Show all' ]
            ],
            "buttons": [
                {
                    extend: 'pageLength',
                },
                {
                    extend: 'colvis',
                    columns: ':not(.noVis)',
                    text: 'Select Columns',
                },
                {
                    extend: 'copyHtml5',
                    exportOptions: {
                        columns: ':visible:not(.action-column,.select-all-checkbox)',
                        format: {
                            body: function ( data, row, column, node ) {
                                if($(node).find('.dropdown-menu').length > 0){
                                    $(node).find('.dropdown-menu').remove();
                                }
                                if($(node).find('img').length > 0){
                                    return $(node).find('img').attr('src');
                                }
                                return $(node).text().trim();
                            }
                        }
                    },
                },
                {
                    extend: 'print',
                    exportOptions: {
                        columns: ':visible:not(.action-column,.select-all-checkbox)',
                        format: {
                            body: function ( data, row, column, node ) {
                                if($(node).find('.dropdown-menu').length > 0){
                                    $(node).find('.dropdown-menu').remove();
                                }
                                if($(node).find('img').length > 0){
                                    return $(node).find('img').attr('src');
                                }
                                return $(node).text().trim();
                            }
                        }
                    },
                },
                {
                    extend: 'excelHtml5',
                    autoFilter: true,
                    sheetName: 'Exported data',
                    exportOptions: {
                        columns: ':visible:not(.action-column,.select-all-checkbox)',
                        format: {
                            body: function ( data, row, column, node ) {
                                if($(node).find('.dropdown-menu').length > 0){
                                    $(node).find('.dropdown-menu').remove();
                                }
                                if($(node).find('img').length > 0){
                                    return $(node).find('img').attr('src');
                                }
                                return $(node).text().trim();
                            }
                        }
                    },
                },
                {
                    extend: 'csvHtml5',
                    exportOptions: {
                        columns: ':visible:not(.action-column,.select-all-checkbox)',
                        format: {
                            body: function ( data, row, column, node ) {
                                if($(node).find('.dropdown-menu').length > 0){
                                    $(node).find('.dropdown-menu').remove();
                                }
                                if($(node).find('img').length > 0){
                                    return $(node).find('img').attr('src');
                                }
                                return $(node).text().trim();
                            }
                        }
                    },
                },
                {
                    extend: 'pdfHtml5',
                    exportOptions: {
                        columns: ':visible:not(.action-column,.select-all-checkbox)',
                        format: {
                            body: function ( data, row, column, node ) {
                                if($(node).find('.dropdown-menu').length > 0){
                                    $(node).find('.dropdown-menu').remove();
                                }
                                if($(node).find('img').length > 0){
                                    return $(node).find('img').attr('src');
                                }
                                return $(node).text().trim();
                            }
                        }
                    },
                    download: 'open',
                },
            ],
            /* searchPanes: {
                columns: [2, 3,4]
            },
            columnDefs: [{
                searchPanes: {
                    show: true
                },
                targets: [2, 3,4]
            }], */
            "processing": true, //Feature control the processing indicator.
            "serverSide": true, //Feature control DataTables' server-side processing mode.
            "order": [], //Initial no order.
            "ajax": {
                "url": "<?=$datatable_url ?? '';?>",
                "type": "POST",
            },
            "deferRender": true,
            "columns": <?=$data_columns;?>,
            "drawCallback": function(){
                $("a.image_url").fancybox();
                $("a.video_url").fancybox();
            },
            "initComplete":function( settings, json){
                $(".dt-buttons button").each(function(){
                    var $e = $(this); 
                    $e.removeClass('btn-secondary').addClass('text-white');
                });
                $(".dt-buttons").addClass('bg-gradient-secondary');
                // $($.fn.dataTable.tables(true)).DataTable().columns.adjust().responsive.recalc();
            },
        });
        // }).buttons().container().appendTo('#datatable_wrapper .col-md-6:eq(0)');

        table
        .on( 'select', function ( e, dt, type, indexes ) {
            var rowData = table.rows( indexes ).data().toArray();
            $.each(rowData, function(index, field) {
                if(field.checkbox){
                    var checkbox_id = $(field.checkbox).find('input[type=checkbox]').attr('id');
                    $('#'+checkbox_id).prop('checked',true).change();
                }
            });
        } )
        .on( 'deselect', function ( e, dt, type, indexes ) {
            var rowData = table.rows( indexes ).data().toArray();
            $.each(rowData, function(index, field) {
                if(field.checkbox){
                    var checkbox_id = $(field.checkbox).find('input[type=checkbox]').attr('id');
                    $('#'+checkbox_id).prop('checked',false).change();
                }
            });
        } )
        .on( 'draw.dt', function () {
            $("#md_checkbox_all").prop('checked', false).change();
        } )
        /* .on( 'length.dt', function () {
            $("#md_checkbox_all").prop('checked', false).change();
        } )
        .on( 'page.dt', function () {
            $("#md_checkbox_all").prop('checked', false).change();
        } ) */
        ;
    }

    var date_ranges_filters = new Array(<?=implode(',',array_map(function($val){return sprintf("'%s'", $val);}, MY_DATE_FIELDS));?>);
    function apply_filters(){
        var filters = new Array();
        <?php if(isset($columns) && count($columns) > 0){ ?>
            <?php foreach($columns as $filter){ ?>
                <?php if(isset($filter['id']) && !empty($filter['id'])){ ?>
                    filters.push("<?=$filter['id'];?>");
                <?php }else{ ?>
                    filters.push("");
                <?php } ?>
            <?php } ?>
        <?php } ?>
        for(filter in filters){
            if(filters[filter] != ''){
                if($(".frm_filter #"+filters[filter]).length > 0){
                    if(date_ranges_filters.indexOf(filters[filter]) >= 0){
                        if(
                            $(".frm_filter #"+filters[filter]).hasClass("dateranges") &&  
                            $(".frm_filter #md_checkbox_"+filters[filter]+":checked").val() == "on"
                        ){
                            var value = $(".frm_filter #"+filters[filter]).val();
                            var my_date_range = value.split(" - ").join("|");
                            table.column(filter).search(my_date_range);
                        }else{
                            table.column(filter).search("");
                        }
                    }else{
                        var value = $(".frm_filter #"+filters[filter]).val();
                        table.column(filter).search(value);
                    }
                }
            }
        }
        table.draw();
        $("th.select-all-checkbox .checkb_main [type=checkbox]").prop('checked', false);
        $(".close").trigger('click');
    }

    <?php if(isset($form_filter)): ?>
        $('#<?=$form_filter['id'];?>').on('submit', function (e) {
            if (e.isDefaultPrevented()) {
                // handle the invalid form...
            } else {
                apply_filters();
                return false;
            }
        });
        $('#<?=$form_filter['id'];?> #btn_filter_reset').on('click',function(){
            $('.frm_filter [id^="md_checkbox_"]:checked').each(function () {
                var filter_id = $(this).data('filter-id');
                $(this).prop('checked',false);
                $('.frm_filter #' + filter_id).hide();
                $('.frm_filter #' + filter_id).val('')
            });
            $('#<?=$form_filter['id'];?>').trigger("reset");
            apply_filters();
            return false;
        });
    <?php endif; ?>
});

$(document).ready(function(){
    $(document).on('click', ".statusmgt", function () {
        var formdata = new FormData();
        formdata.append('id', $(this).data('id'));
        formdata.append('status', $(this).data('status'));
        formdata.append('module', $(this).data('module'));

        $.ajax({
            url: '<?=ADMIN_AJAX_URL;?>' + "update-status",
            data: formdata,
            processData: false,
            contentType: false,
            type: 'POST',
            dataType: 'JSON',
            beforeSend: function () {
                loading('show');
            },
            success: function (response) {
                loading('hide');
                if(response.success){
                    notify(response.message, 'success');
                }else{
                    notify(response.message,'danger');
                }
                table.ajax.reload();
            },
            fail: function(xhr, textStatus, errorThrown){
                loading('hide');
                sweetalert('<?=SYSTEM_ERROR;?>',"error");
                $btn_submit.attr('disabled',false);
                $btn_submit.html(before_name);
            },
            error: function (err) {
                loading('hide');
                sweetalert('<?=SYSTEM_ERROR;?>',"error");
                $btn_submit.attr('disabled',false);
                $btn_submit.html(before_name);
            },
            complete: function () {}
        });
        return false;
    });
    
    $(document).on('click', ".bulk-action", function () {
        var formdata = new FormData();
        var checked = [];
        $(".dataTables_wrapper [id^='md_checkbox_']:not('#md_checkbox_all'):checked").each(function () {
            checked.push($(this).val());
        });
        formdata.append('ids', checked.join(','));
        formdata.append('status', $(this).data('status'));
        formdata.append('module', $(this).data('module'));

        $.ajax({
            url: '<?=ADMIN_AJAX_URL;?>' + "update-status-bulk",
            data: formdata,
            processData: false,
            contentType: false,
            type: 'POST',
            dataType: 'JSON',
            beforeSend: function () {
                loading('show');
            },
            success: function (response) {
                loading('hide');
                if(response.success){
                    notify(response.message, 'success');
                }else{
                    notify(response.message,'danger');
                }
                $("#bulkActionButton").dropdown("toggle");
                $("#bulk_actions_dropdown").hide();
                $("#md_checkbox_all").prop("checked",false)
                table.ajax.reload();
            },
            fail: function(xhr, textStatus, errorThrown){
                loading('hide');
                sweetalert('<?=SYSTEM_ERROR;?>',"error");
                $btn_submit.attr('disabled',false);
                $btn_submit.html(before_name);
            },
            error: function (err) {
                loading('hide');
                sweetalert('<?=SYSTEM_ERROR;?>',"error");
                $btn_submit.attr('disabled',false);
                $btn_submit.html(before_name);
            },
            complete: function () {}
        });
        return false;
    });

    $(document).on('click', ".deletelink", function () {
        Swal.fire({
            title: 'Are you sure, do you want to delete this record?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: `Delete Now`,
            // denyButtonText: `Cancel`,
        }).then((result) => {
            if (result.isConfirmed) {
                var formdata = new FormData();
                formdata.append('id', $(this).data('id'));
                formdata.append('module', $(this).data('module'));

                $.ajax({
                    url: '<?=ADMIN_AJAX_URL;?>' + "delete-record",
                    data: formdata,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'JSON',
                    beforeSend: function () {
                        loading('show');
                    },
                    success: function (response) {
                        loading('hide');
                        window.location.reload();
                    },
                    fail: function(xhr, textStatus, errorThrown){
                        loading('hide');
                        sweetalert('<?=SYSTEM_ERROR;?>',"error");
                        $btn_submit.attr('disabled',false);
                        $btn_submit.html(before_name);
                    },
                    error: function (err) {
                        loading('hide');
                        sweetalert('<?=SYSTEM_ERROR;?>',"error");
                        $btn_submit.attr('disabled',false);
                        $btn_submit.html(before_name);
                    },
                    complete: function () {}
                });
                return false;
            }
        });
    });
});
</script>